<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type');

require_once 'db.php';

$response = ['success' => false, 'message' => ''];

try {
    // Get JSON input
    $json = file_get_contents('php://input');
    $input = json_decode($json, true);
    
    if (json_last_error() !== JSON_ERROR_NONE) {
        throw new Exception('Invalid JSON format');
    }
    
    // Validate input
    if (empty($input['id'])) {
        throw new Exception('Category ID is required');
    }

    // Sanitize input
    $id = $conn->real_escape_string(trim($input['id']));
    
    // Update query to soft delete
    $sql = "UPDATE blog_category SET Delete_status = 1 WHERE Blog_category_id = '$id'";
    
    if ($conn->query($sql)) {
        if ($conn->affected_rows > 0) {
            $response = [
                'success' => true,
                'message' => 'Category deleted successfully'
            ];
        } else {
            throw new Exception('No category found with this ID');
        }
    } else {
        throw new Exception('Database error: ' . $conn->error);
    }
} catch (Exception $e) {
    $response['message'] = $e->getMessage();
    http_response_code(400); // Bad request
}

$conn->close();
echo json_encode($response);
?>